import json
import re

def extract_scores_from_jsonl(filepath):
    scores = []
    
    with open(filepath, 'r', encoding='utf-8') as file:
        for line in file:
            item = json.loads(line.strip())
            
            style_score = item['scores']['style']
            if isinstance(style_score, str):
                style_score = re.search(r"\[\[(\d+)\]\]", style_score)
                if style_score:
                    style_score = int(style_score.group(1))
            elif isinstance(style_score, int):
                style_score = style_score
            
            engaging_score = item['scores']['engaging']
            if isinstance(engaging_score, str):
                engaging_score = re.search(r"\[\[(\d+)\]\]", engaging_score)
                if engaging_score:
                    engaging_score = int(engaging_score.group(1))
            elif isinstance(engaging_score, int):
                engaging_score = engaging_score

            coherence_score = item['scores']['coherence']
            if isinstance(coherence_score, str):
                coherence_score = re.search(r"\[\[(\d+)\]\]", coherence_score)
                if coherence_score:
                    coherence_score = int(coherence_score.group(1))
            elif isinstance(coherence_score, int):
                coherence_score = coherence_score
            
            style_score = style_score if style_score is not None else 0
            engaging_score = engaging_score if engaging_score is not None else 0
            coherence_score = coherence_score if coherence_score is not None else 0
            
            scores.append({
                'item_id': item['item_id'],
                'style': style_score,
                'engaging': engaging_score,
                'coherence': coherence_score
            })
    
    return scores

def save_scores_to_file(scores, output_filepath):
    with open(output_filepath, 'w', encoding='utf-8') as output_file:
        for score in scores:
            output_file.write(json.dumps(score) + '\n')

def main():
    filepath = './output_hae.jsonl'  # Please give the corrected file path 
    output_filepath = '/root/Story-result/output_hae_score.jsonl'  
    
    # Get Scores
    scores = extract_scores_from_jsonl(filepath)
    
    # Save
    save_scores_to_file(scores, output_filepath)

    print(f"Scores have been saved to {output_filepath}")

if __name__ == "__main__":
    main()
